package io.k8s.api.storage.v1


/** VolumeAttachmentStatus is the status of a VolumeAttachment request. */
final case class VolumeAttachmentStatus(
  attachError : Option[io.k8s.api.storage.v1.VolumeError] = None,
  attached : Boolean,
  attachmentMetadata : Option[Map[String, String]] = None,
  detachError : Option[io.k8s.api.storage.v1.VolumeError] = None
) {
  def withAttachError(value: io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(attachError = Some(value))
  def withAttached(value: Boolean) : VolumeAttachmentStatus = copy(attached = value)
  def withAttachmentMetadata(value: Map[String, String]) : VolumeAttachmentStatus = copy(attachmentMetadata = Some(value))
  def addAttachmentMetadata(newValues: (String, String)*) : VolumeAttachmentStatus = copy(attachmentMetadata = Some(attachmentMetadata.fold(newValues.toMap)(_ ++ newValues)))

  def withDetachError(value: io.k8s.api.storage.v1.VolumeError) : VolumeAttachmentStatus = copy(detachError = Some(value))
}

