package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** VolumeAttachment captures the intent to attach or detach the specified volume to/from the specified node.

VolumeAttachment objects are non-namespaced. */
final case class VolumeAttachment(
  status : Option[io.k8s.api.storage.v1.VolumeAttachmentStatus] = None,
  spec : io.k8s.api.storage.v1.VolumeAttachmentSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "VolumeAttachment", "v1")

  def withStatus(value: io.k8s.api.storage.v1.VolumeAttachmentStatus) : VolumeAttachment = copy(status = Some(value))
  def withSpec(value: io.k8s.api.storage.v1.VolumeAttachmentSpec) : VolumeAttachment = copy(spec = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : VolumeAttachment = copy(metadata = Some(value))
}

