package io.k8s.api.storage.v1


/** TokenRequest contains parameters of a service account token. */
final case class TokenRequest(
  audience : String,
  expirationSeconds : Option[Int] = None
) {
  def withAudience(value: String) : TokenRequest = copy(audience = value)
  def withExpirationSeconds(value: Int) : TokenRequest = copy(expirationSeconds = Some(value))
}

