package io.k8s.api.storage.v1


/** CSINodeDriver holds information about the specification of one CSI driver installed on a node */
final case class CSINodeDriver(
  allocatable : Option[io.k8s.api.storage.v1.VolumeNodeResources] = None,
  name : String,
  nodeID : String,
  topologyKeys : Option[Seq[String]] = None
) {
  def withAllocatable(value: io.k8s.api.storage.v1.VolumeNodeResources) : CSINodeDriver = copy(allocatable = Some(value))
  def withName(value: String) : CSINodeDriver = copy(name = value)
  def withNodeID(value: String) : CSINodeDriver = copy(nodeID = value)
  def withTopologyKeys(value: Seq[String]) : CSINodeDriver = copy(topologyKeys = Some(value))
  def addTopologyKeys(newValues: String*) : CSINodeDriver = copy(topologyKeys = Some(topologyKeys.fold(newValues)(_ ++ newValues)))

}

