package io.k8s.api.storage.v1

import dev.hnaderi.k8s._

/** CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster. Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced. */
final case class CSIDriver(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  spec : io.k8s.api.storage.v1.CSIDriverSpec
) extends KObject {
  protected val _resourceKind = ResourceKind("storage.k8s.io", "CSIDriver", "v1")

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CSIDriver = copy(metadata = Some(value))
  def withSpec(value: io.k8s.api.storage.v1.CSIDriverSpec) : CSIDriver = copy(spec = value)
}

