package io.k8s.api.scheduling.v1

import dev.hnaderi.k8s._

/** PriorityClassList is a collection of priority classes. */
final case class PriorityClassList(
  items : Seq[io.k8s.api.scheduling.v1.PriorityClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("scheduling.k8s.io", "PriorityClassList", "v1")

  def withItems(value: Seq[io.k8s.api.scheduling.v1.PriorityClass]) : PriorityClassList = copy(items = value)
  def addItems(newValues: io.k8s.api.scheduling.v1.PriorityClass*) : PriorityClassList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityClassList = copy(metadata = Some(value))
}

