package io.k8s.api.scheduling.v1

import dev.hnaderi.k8s._

/** PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer. */
final case class PriorityClass(
  description : Option[String] = None,
  globalDefault : Option[Boolean] = None,
  preemptionPolicy : Option[String] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  value : Int
) extends KObject {
  protected val _resourceKind = ResourceKind("scheduling.k8s.io", "PriorityClass", "v1")

  def withDescription(value: String) : PriorityClass = copy(description = Some(value))
  def withGlobalDefault(value: Boolean) : PriorityClass = copy(globalDefault = Some(value))
  def withPreemptionPolicy(value: String) : PriorityClass = copy(preemptionPolicy = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PriorityClass = copy(metadata = Some(value))
  def withValue(value: Int) : PriorityClass = copy(value = value)
}

