package io.k8s.api.rbac.v1


/** PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to. */
final case class PolicyRule(
  verbs : Seq[String],
  apiGroups : Option[Seq[String]] = None,
  resources : Option[Seq[String]] = None,
  resourceNames : Option[Seq[String]] = None,
  nonResourceURLs : Option[Seq[String]] = None
) {
  def withVerbs(value: Seq[String]) : PolicyRule = copy(verbs = value)
  def addVerbs(newValues: String*) : PolicyRule = copy(verbs = verbs ++ newValues)

  def withApiGroups(value: Seq[String]) : PolicyRule = copy(apiGroups = Some(value))
  def addApiGroups(newValues: String*) : PolicyRule = copy(apiGroups = Some(apiGroups.fold(newValues)(_ ++ newValues)))

  def withResources(value: Seq[String]) : PolicyRule = copy(resources = Some(value))
  def addResources(newValues: String*) : PolicyRule = copy(resources = Some(resources.fold(newValues)(_ ++ newValues)))

  def withResourceNames(value: Seq[String]) : PolicyRule = copy(resourceNames = Some(value))
  def addResourceNames(newValues: String*) : PolicyRule = copy(resourceNames = Some(resourceNames.fold(newValues)(_ ++ newValues)))

  def withNonResourceURLs(value: Seq[String]) : PolicyRule = copy(nonResourceURLs = Some(value))
  def addNonResourceURLs(newValues: String*) : PolicyRule = copy(nonResourceURLs = Some(nonResourceURLs.fold(newValues)(_ ++ newValues)))

}

