package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._

/** ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding. */
final case class ClusterRole(
  aggregationRule : Option[io.k8s.api.rbac.v1.AggregationRule] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  rules : Option[Seq[io.k8s.api.rbac.v1.PolicyRule]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "ClusterRole", "v1")

  def withAggregationRule(value: io.k8s.api.rbac.v1.AggregationRule) : ClusterRole = copy(aggregationRule = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ClusterRole = copy(metadata = Some(value))
  def withRules(value: Seq[io.k8s.api.rbac.v1.PolicyRule]) : ClusterRole = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.rbac.v1.PolicyRule*) : ClusterRole = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

}

