package io.k8s.api.node.v1


/** Scheduling specifies the scheduling constraints for nodes supporting a RuntimeClass. */
final case class Scheduling(
  nodeSelector : Option[Map[String, String]] = None,
  tolerations : Option[Seq[io.k8s.api.core.v1.Toleration]] = None
) {
  def withNodeSelector(value: Map[String, String]) : Scheduling = copy(nodeSelector = Some(value))
  def addNodeSelector(newValues: (String, String)*) : Scheduling = copy(nodeSelector = Some(nodeSelector.fold(newValues.toMap)(_ ++ newValues)))

  def withTolerations(value: Seq[io.k8s.api.core.v1.Toleration]) : Scheduling = copy(tolerations = Some(value))
  def addTolerations(newValues: io.k8s.api.core.v1.Toleration*) : Scheduling = copy(tolerations = Some(tolerations.fold(newValues)(_ ++ newValues)))

}

