package io.k8s.api.node.v1

import dev.hnaderi.k8s._

/** RuntimeClassList is a list of RuntimeClass objects. */
final case class RuntimeClassList(
  items : Seq[io.k8s.api.node.v1.RuntimeClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("node.k8s.io", "RuntimeClassList", "v1")

  def withItems(value: Seq[io.k8s.api.node.v1.RuntimeClass]) : RuntimeClassList = copy(items = value)
  def addItems(newValues: io.k8s.api.node.v1.RuntimeClass*) : RuntimeClassList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RuntimeClassList = copy(metadata = Some(value))
}

