package io.k8s.api.node.v1


/** Overhead structure represents the resource overhead associated with running a pod. */
final case class Overhead(
  podFixed : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {
  def withPodFixed(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : Overhead = copy(podFixed = Some(value))
  def addPodFixed(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : Overhead = copy(podFixed = Some(podFixed.fold(newValues.toMap)(_ ++ newValues)))

}

