package io.k8s.api.networking.v1


/** ServiceBackendPort is the service port being referenced. */
final case class ServiceBackendPort(
  name : Option[String] = None,
  number : Option[Int] = None
) {
  def withName(value: String) : ServiceBackendPort = copy(name = Some(value))
  def withNumber(value: Int) : ServiceBackendPort = copy(number = Some(value))
}

