package io.k8s.api.networking.v1


/** NetworkPolicyStatus describe the current state of the NetworkPolicy. */
final case class NetworkPolicyStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None
) {
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : NetworkPolicyStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : NetworkPolicyStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

}

