package io.k8s.api.networking.v1


/** NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from. */
final case class NetworkPolicyIngressRule(
  from : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None,
  ports : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None
) {
  def withFrom(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyIngressRule = copy(from = Some(value))
  def addFrom(newValues: io.k8s.api.networking.v1.NetworkPolicyPeer*) : NetworkPolicyIngressRule = copy(from = Some(from.fold(newValues)(_ ++ newValues)))

  def withPorts(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyIngressRule = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.networking.v1.NetworkPolicyPort*) : NetworkPolicyIngressRule = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

}

