package io.k8s.api.networking.v1


/** NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to. This type is beta-level in 1.8 */
final case class NetworkPolicyEgressRule(
  ports : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPort]] = None,
  to : Option[Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]] = None
) {
  def withPorts(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPort]) : NetworkPolicyEgressRule = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.networking.v1.NetworkPolicyPort*) : NetworkPolicyEgressRule = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

  def withTo(value: Seq[io.k8s.api.networking.v1.NetworkPolicyPeer]) : NetworkPolicyEgressRule = copy(to = Some(value))
  def addTo(newValues: io.k8s.api.networking.v1.NetworkPolicyPeer*) : NetworkPolicyEgressRule = copy(to = Some(to.fold(newValues)(_ ++ newValues)))

}

