package io.k8s.api.networking.v1


/** IngressSpec describes the Ingress the user wishes to exist. */
final case class IngressSpec(
  defaultBackend : Option[io.k8s.api.networking.v1.IngressBackend] = None,
  ingressClassName : Option[String] = None,
  rules : Option[Seq[io.k8s.api.networking.v1.IngressRule]] = None,
  tls : Option[Seq[io.k8s.api.networking.v1.IngressTLS]] = None
) {
  def withDefaultBackend(value: io.k8s.api.networking.v1.IngressBackend) : IngressSpec = copy(defaultBackend = Some(value))
  def withIngressClassName(value: String) : IngressSpec = copy(ingressClassName = Some(value))
  def withRules(value: Seq[io.k8s.api.networking.v1.IngressRule]) : IngressSpec = copy(rules = Some(value))
  def addRules(newValues: io.k8s.api.networking.v1.IngressRule*) : IngressSpec = copy(rules = Some(rules.fold(newValues)(_ ++ newValues)))

  def withTls(value: Seq[io.k8s.api.networking.v1.IngressTLS]) : IngressSpec = copy(tls = Some(value))
  def addTls(newValues: io.k8s.api.networking.v1.IngressTLS*) : IngressSpec = copy(tls = Some(tls.fold(newValues)(_ ++ newValues)))

}

