package io.k8s.api.networking.v1


/** IngressServiceBackend references a Kubernetes Service as a Backend. */
final case class IngressServiceBackend(
  name : String,
  port : Option[io.k8s.api.networking.v1.ServiceBackendPort] = None
) {
  def withName(value: String) : IngressServiceBackend = copy(name = value)
  def withPort(value: io.k8s.api.networking.v1.ServiceBackendPort) : IngressServiceBackend = copy(port = Some(value))
}

