package io.k8s.api.networking.v1


/** IngressClassSpec provides information about the class of an Ingress. */
final case class IngressClassSpec(
  controller : Option[String] = None,
  parameters : Option[io.k8s.api.networking.v1.IngressClassParametersReference] = None
) {
  def withController(value: String) : IngressClassSpec = copy(controller = Some(value))
  def withParameters(value: io.k8s.api.networking.v1.IngressClassParametersReference) : IngressClassSpec = copy(parameters = Some(value))
}

