package io.k8s.api.networking.v1


/** IngressClassParametersReference identifies an API object. This can be used to specify a cluster or namespace-scoped resource. */
final case class IngressClassParametersReference(
  name : String,
  scope : Option[String] = None,
  apiGroup : Option[String] = None,
  namespace : Option[String] = None
) {
  def withName(value: String) : IngressClassParametersReference = copy(name = value)
  def withScope(value: String) : IngressClassParametersReference = copy(scope = Some(value))
  def withApiGroup(value: String) : IngressClassParametersReference = copy(apiGroup = Some(value))
  def withNamespace(value: String) : IngressClassParametersReference = copy(namespace = Some(value))
}

