package io.k8s.api.networking.v1

import dev.hnaderi.k8s._

/** IngressClassList is a collection of IngressClasses. */
final case class IngressClassList(
  items : Seq[io.k8s.api.networking.v1.IngressClass],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("networking.k8s.io", "IngressClassList", "v1")

  def withItems(value: Seq[io.k8s.api.networking.v1.IngressClass]) : IngressClassList = copy(items = value)
  def addItems(newValues: io.k8s.api.networking.v1.IngressClass*) : IngressClassList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : IngressClassList = copy(metadata = Some(value))
}

