package io.k8s.api.networking.v1


/** IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule. */
final case class IPBlock(
  cidr : String,
  except : Option[Seq[String]] = None
) {
  def withCidr(value: String) : IPBlock = copy(cidr = value)
  def withExcept(value: Seq[String]) : IPBlock = copy(except = Some(value))
  def addExcept(newValues: String*) : IPBlock = copy(except = Some(except.fold(newValues)(_ ++ newValues)))

}

