package io.k8s.api.flowcontrol.v1beta2


/** ResourcePolicyRule is a predicate that matches some resource requests, testing the request's verb and the target resource. A ResourcePolicyRule matches a resource request if and only if: (a) at least one member of verbs matches the request, (b) at least one member of apiGroups matches the request, (c) at least one member of resources matches the request, and (d) either (d1) the request does not specify a namespace (i.e., `Namespace==""`) and clusterScope is true or (d2) the request specifies a namespace and least one member of namespaces matches the request's namespace. */
final case class ResourcePolicyRule(
  clusterScope : Option[Boolean] = None,
  verbs : Seq[String],
  apiGroups : Seq[String],
  namespaces : Option[Seq[String]] = None,
  resources : Seq[String]
) {
  def withClusterScope(value: Boolean) : ResourcePolicyRule = copy(clusterScope = Some(value))
  def withVerbs(value: Seq[String]) : ResourcePolicyRule = copy(verbs = value)
  def addVerbs(newValues: String*) : ResourcePolicyRule = copy(verbs = verbs ++ newValues)

  def withApiGroups(value: Seq[String]) : ResourcePolicyRule = copy(apiGroups = value)
  def addApiGroups(newValues: String*) : ResourcePolicyRule = copy(apiGroups = apiGroups ++ newValues)

  def withNamespaces(value: Seq[String]) : ResourcePolicyRule = copy(namespaces = Some(value))
  def addNamespaces(newValues: String*) : ResourcePolicyRule = copy(namespaces = Some(namespaces.fold(newValues)(_ ++ newValues)))

  def withResources(value: Seq[String]) : ResourcePolicyRule = copy(resources = value)
  def addResources(newValues: String*) : ResourcePolicyRule = copy(resources = resources ++ newValues)

}

