package io.k8s.api.flowcontrol.v1beta2


/** QueuingConfiguration holds the configuration parameters for queuing */
final case class QueuingConfiguration(
  handSize : Option[Int] = None,
  queueLengthLimit : Option[Int] = None,
  queues : Option[Int] = None
) {
  def withHandSize(value: Int) : QueuingConfiguration = copy(handSize = Some(value))
  def withQueueLengthLimit(value: Int) : QueuingConfiguration = copy(queueLengthLimit = Some(value))
  def withQueues(value: Int) : QueuingConfiguration = copy(queues = Some(value))
}

