package io.k8s.api.flowcontrol.v1beta2

import dev.hnaderi.k8s._

/** PriorityLevelConfigurationList is a list of PriorityLevelConfiguration objects. */
final case class PriorityLevelConfigurationList(
  items : Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("flowcontrol.apiserver.k8s.io", "PriorityLevelConfigurationList", "v1beta2")

  def withItems(value: Seq[io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration]) : PriorityLevelConfigurationList = copy(items = value)
  def addItems(newValues: io.k8s.api.flowcontrol.v1beta2.PriorityLevelConfiguration*) : PriorityLevelConfigurationList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PriorityLevelConfigurationList = copy(metadata = Some(value))
}

