package io.k8s.api.flowcontrol.v1beta2


/** PolicyRulesWithSubjects prescribes a test that applies to a request to an apiserver. The test considers the subject making the request, the verb being requested, and the resource to be acted upon. This PolicyRulesWithSubjects matches a request if and only if both (a) at least one member of subjects matches the request and (b) at least one member of resourceRules or nonResourceRules matches the request. */
final case class PolicyRulesWithSubjects(
  nonResourceRules : Option[Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]] = None,
  resourceRules : Option[Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]] = None,
  subjects : Seq[io.k8s.api.flowcontrol.v1beta2.Subject]
) {
  def withNonResourceRules(value: Seq[io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule]) : PolicyRulesWithSubjects = copy(nonResourceRules = Some(value))
  def addNonResourceRules(newValues: io.k8s.api.flowcontrol.v1beta2.NonResourcePolicyRule*) : PolicyRulesWithSubjects = copy(nonResourceRules = Some(nonResourceRules.fold(newValues)(_ ++ newValues)))

  def withResourceRules(value: Seq[io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule]) : PolicyRulesWithSubjects = copy(resourceRules = Some(value))
  def addResourceRules(newValues: io.k8s.api.flowcontrol.v1beta2.ResourcePolicyRule*) : PolicyRulesWithSubjects = copy(resourceRules = Some(resourceRules.fold(newValues)(_ ++ newValues)))

  def withSubjects(value: Seq[io.k8s.api.flowcontrol.v1beta2.Subject]) : PolicyRulesWithSubjects = copy(subjects = value)
  def addSubjects(newValues: io.k8s.api.flowcontrol.v1beta2.Subject*) : PolicyRulesWithSubjects = copy(subjects = subjects ++ newValues)

}

