package io.k8s.api.flowcontrol.v1beta2


/** NonResourcePolicyRule is a predicate that matches non-resource requests according to their verb and the target non-resource URL. A NonResourcePolicyRule matches a request if and only if both (a) at least one member of verbs matches the request and (b) at least one member of nonResourceURLs matches the request. */
final case class NonResourcePolicyRule(
  nonResourceURLs : Seq[String],
  verbs : Seq[String]
) {
  def withNonResourceURLs(value: Seq[String]) : NonResourcePolicyRule = copy(nonResourceURLs = value)
  def addNonResourceURLs(newValues: String*) : NonResourcePolicyRule = copy(nonResourceURLs = nonResourceURLs ++ newValues)

  def withVerbs(value: Seq[String]) : NonResourcePolicyRule = copy(verbs = value)
  def addVerbs(newValues: String*) : NonResourcePolicyRule = copy(verbs = verbs ++ newValues)

}

