package io.k8s.api.flowcontrol.v1beta1


/** Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account. */
final case class Subject(
  group : Option[io.k8s.api.flowcontrol.v1beta1.GroupSubject] = None,
  serviceAccount : Option[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject] = None,
  user : Option[io.k8s.api.flowcontrol.v1beta1.UserSubject] = None
) {
  def withGroup(value: io.k8s.api.flowcontrol.v1beta1.GroupSubject) : Subject = copy(group = Some(value))
  def withServiceAccount(value: io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject) : Subject = copy(serviceAccount = Some(value))
  def withUser(value: io.k8s.api.flowcontrol.v1beta1.UserSubject) : Subject = copy(user = Some(value))
}

