package io.k8s.api.flowcontrol.v1beta1


/** LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
  - How are requests for this priority level limited?
  - What should be done with requests that exceed the limit? */
final case class LimitedPriorityLevelConfiguration(
  assuredConcurrencyShares : Option[Int] = None,
  limitResponse : Option[io.k8s.api.flowcontrol.v1beta1.LimitResponse] = None
) {
  def withAssuredConcurrencyShares(value: Int) : LimitedPriorityLevelConfiguration = copy(assuredConcurrencyShares = Some(value))
  def withLimitResponse(value: io.k8s.api.flowcontrol.v1beta1.LimitResponse) : LimitedPriorityLevelConfiguration = copy(limitResponse = Some(value))
}

