package io.k8s.api.flowcontrol.v1beta1


/** FlowSchemaStatus represents the current state of a FlowSchema. */
final case class FlowSchemaStatus(
  conditions : Option[Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]] = None
) {
  def withConditions(value: Seq[io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition]) : FlowSchemaStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.api.flowcontrol.v1beta1.FlowSchemaCondition*) : FlowSchemaStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

}

