package io.k8s.api.events.v1

import dev.hnaderi.k8s._

/** Event is a report of an event somewhere in the cluster. It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data. */
final case class Event(
  regarding : Option[io.k8s.api.core.v1.ObjectReference] = None,
  series : Option[io.k8s.api.events.v1.EventSeries] = None,
  reason : Option[String] = None,
  deprecatedCount : Option[Int] = None,
  related : Option[io.k8s.api.core.v1.ObjectReference] = None,
  deprecatedFirstTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  note : Option[String] = None,
  reportingController : Option[String] = None,
  eventTime : io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  deprecatedSource : Option[io.k8s.api.core.v1.EventSource] = None,
  `type` : Option[String] = None,
  deprecatedLastTimestamp : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reportingInstance : Option[String] = None,
  action : Option[String] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("events.k8s.io", "Event", "v1")

  def withRegarding(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(regarding = Some(value))
  def withSeries(value: io.k8s.api.events.v1.EventSeries) : Event = copy(series = Some(value))
  def withReason(value: String) : Event = copy(reason = Some(value))
  def withDeprecatedCount(value: Int) : Event = copy(deprecatedCount = Some(value))
  def withRelated(value: io.k8s.api.core.v1.ObjectReference) : Event = copy(related = Some(value))
  def withDeprecatedFirstTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedFirstTimestamp = Some(value))
  def withNote(value: String) : Event = copy(note = Some(value))
  def withReportingController(value: String) : Event = copy(reportingController = Some(value))
  def withEventTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.MicroTime) : Event = copy(eventTime = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Event = copy(metadata = Some(value))
  def withDeprecatedSource(value: io.k8s.api.core.v1.EventSource) : Event = copy(deprecatedSource = Some(value))
  def withType(value: String) : Event = copy(`type` = Some(value))
  def withDeprecatedLastTimestamp(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Event = copy(deprecatedLastTimestamp = Some(value))
  def withReportingInstance(value: String) : Event = copy(reportingInstance = Some(value))
  def withAction(value: String) : Event = copy(action = Some(value))
}

