package io.k8s.api.discovery.v1

import dev.hnaderi.k8s._

/** EndpointSliceList represents a list of endpoint slices */
final case class EndpointSliceList(
  items : Seq[io.k8s.api.discovery.v1.EndpointSlice],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("discovery.k8s.io", "EndpointSliceList", "v1")

  def withItems(value: Seq[io.k8s.api.discovery.v1.EndpointSlice]) : EndpointSliceList = copy(items = value)
  def addItems(newValues: io.k8s.api.discovery.v1.EndpointSlice*) : EndpointSliceList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : EndpointSliceList = copy(metadata = Some(value))
}

