package io.k8s.api.discovery.v1

import dev.hnaderi.k8s._

/** EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints. */
final case class EndpointSlice(
  endpoints : Seq[io.k8s.api.discovery.v1.Endpoint],
  ports : Option[Seq[io.k8s.api.discovery.v1.EndpointPort]] = None,
  addressType : String,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("discovery.k8s.io", "EndpointSlice", "v1")

  def withEndpoints(value: Seq[io.k8s.api.discovery.v1.Endpoint]) : EndpointSlice = copy(endpoints = value)
  def addEndpoints(newValues: io.k8s.api.discovery.v1.Endpoint*) : EndpointSlice = copy(endpoints = endpoints ++ newValues)

  def withPorts(value: Seq[io.k8s.api.discovery.v1.EndpointPort]) : EndpointSlice = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.discovery.v1.EndpointPort*) : EndpointSlice = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

  def withAddressType(value: String) : EndpointSlice = copy(addressType = value)
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : EndpointSlice = copy(metadata = Some(value))
}

