package io.k8s.api.discovery.v1


/** EndpointPort represents a Port used by an EndpointSlice */
final case class EndpointPort(
  appProtocol : Option[String] = None,
  name : Option[String] = None,
  port : Option[Int] = None,
  protocol : Option[String] = None
) {
  def withAppProtocol(value: String) : EndpointPort = copy(appProtocol = Some(value))
  def withName(value: String) : EndpointPort = copy(name = Some(value))
  def withPort(value: Int) : EndpointPort = copy(port = Some(value))
  def withProtocol(value: String) : EndpointPort = copy(protocol = Some(value))
}

