package io.k8s.api.discovery.v1


/** EndpointHints provides hints describing how an endpoint should be consumed. */
final case class EndpointHints(
  forZones : Option[Seq[io.k8s.api.discovery.v1.ForZone]] = None
) {
  def withForZones(value: Seq[io.k8s.api.discovery.v1.ForZone]) : EndpointHints = copy(forZones = Some(value))
  def addForZones(newValues: io.k8s.api.discovery.v1.ForZone*) : EndpointHints = copy(forZones = Some(forZones.fold(newValues)(_ ++ newValues)))

}

