package io.k8s.api.discovery.v1


/** EndpointConditions represents the current condition of an endpoint. */
final case class EndpointConditions(
  ready : Option[Boolean] = None,
  serving : Option[Boolean] = None,
  terminating : Option[Boolean] = None
) {
  def withReady(value: Boolean) : EndpointConditions = copy(ready = Some(value))
  def withServing(value: Boolean) : EndpointConditions = copy(serving = Some(value))
  def withTerminating(value: Boolean) : EndpointConditions = copy(terminating = Some(value))
}

