package io.k8s.api.discovery.v1


/** Endpoint represents a single logical "backend" implementing a service. */
final case class Endpoint(
  conditions : Option[io.k8s.api.discovery.v1.EndpointConditions] = None,
  targetRef : Option[io.k8s.api.core.v1.ObjectReference] = None,
  hostname : Option[String] = None,
  nodeName : Option[String] = None,
  hints : Option[io.k8s.api.discovery.v1.EndpointHints] = None,
  deprecatedTopology : Option[Map[String, String]] = None,
  zone : Option[String] = None,
  addresses : Seq[String]
) {
  def withConditions(value: io.k8s.api.discovery.v1.EndpointConditions) : Endpoint = copy(conditions = Some(value))
  def withTargetRef(value: io.k8s.api.core.v1.ObjectReference) : Endpoint = copy(targetRef = Some(value))
  def withHostname(value: String) : Endpoint = copy(hostname = Some(value))
  def withNodeName(value: String) : Endpoint = copy(nodeName = Some(value))
  def withHints(value: io.k8s.api.discovery.v1.EndpointHints) : Endpoint = copy(hints = Some(value))
  def withDeprecatedTopology(value: Map[String, String]) : Endpoint = copy(deprecatedTopology = Some(value))
  def addDeprecatedTopology(newValues: (String, String)*) : Endpoint = copy(deprecatedTopology = Some(deprecatedTopology.fold(newValues.toMap)(_ ++ newValues)))

  def withZone(value: String) : Endpoint = copy(zone = Some(value))
  def withAddresses(value: Seq[String]) : Endpoint = copy(addresses = value)
  def addAddresses(newValues: String*) : Endpoint = copy(addresses = addresses ++ newValues)

}

