package io.k8s.api.core.v1


/** Projection that may be projected along with other supported volume types */
final case class VolumeProjection(
  configMap : Option[io.k8s.api.core.v1.ConfigMapProjection] = None,
  downwardAPI : Option[io.k8s.api.core.v1.DownwardAPIProjection] = None,
  secret : Option[io.k8s.api.core.v1.SecretProjection] = None,
  serviceAccountToken : Option[io.k8s.api.core.v1.ServiceAccountTokenProjection] = None
) {
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapProjection) : VolumeProjection = copy(configMap = Some(value))
  def withDownwardAPI(value: io.k8s.api.core.v1.DownwardAPIProjection) : VolumeProjection = copy(downwardAPI = Some(value))
  def withSecret(value: io.k8s.api.core.v1.SecretProjection) : VolumeProjection = copy(secret = Some(value))
  def withServiceAccountToken(value: io.k8s.api.core.v1.ServiceAccountTokenProjection) : VolumeProjection = copy(serviceAccountToken = Some(value))
}

