package io.k8s.api.core.v1


/** volumeDevice describes a mapping of a raw block device within a container. */
final case class VolumeDevice(
  devicePath : String,
  name : String
) {
  def withDevicePath(value: String) : VolumeDevice = copy(devicePath = value)
  def withName(value: String) : VolumeDevice = copy(name = value)
}

