package io.k8s.api.core.v1


/** Volume represents a named volume in a pod that may be accessed by any container in the pod. */
final case class Volume(
  secret : Option[io.k8s.api.core.v1.SecretVolumeSource] = None,
  scaleIO : Option[io.k8s.api.core.v1.ScaleIOVolumeSource] = None,
  csi : Option[io.k8s.api.core.v1.CSIVolumeSource] = None,
  name : String,
  azureDisk : Option[io.k8s.api.core.v1.AzureDiskVolumeSource] = None,
  azureFile : Option[io.k8s.api.core.v1.AzureFileVolumeSource] = None,
  hostPath : Option[io.k8s.api.core.v1.HostPathVolumeSource] = None,
  rbd : Option[io.k8s.api.core.v1.RBDVolumeSource] = None,
  configMap : Option[io.k8s.api.core.v1.ConfigMapVolumeSource] = None,
  portworxVolume : Option[io.k8s.api.core.v1.PortworxVolumeSource] = None,
  glusterfs : Option[io.k8s.api.core.v1.GlusterfsVolumeSource] = None,
  flocker : Option[io.k8s.api.core.v1.FlockerVolumeSource] = None,
  fc : Option[io.k8s.api.core.v1.FCVolumeSource] = None,
  photonPersistentDisk : Option[io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource] = None,
  gcePersistentDisk : Option[io.k8s.api.core.v1.GCEPersistentDiskVolumeSource] = None,
  persistentVolumeClaim : Option[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = None,
  vsphereVolume : Option[io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource] = None,
  projected : Option[io.k8s.api.core.v1.ProjectedVolumeSource] = None,
  ephemeral : Option[io.k8s.api.core.v1.EphemeralVolumeSource] = None,
  iscsi : Option[io.k8s.api.core.v1.ISCSIVolumeSource] = None,
  cinder : Option[io.k8s.api.core.v1.CinderVolumeSource] = None,
  gitRepo : Option[io.k8s.api.core.v1.GitRepoVolumeSource] = None,
  cephfs : Option[io.k8s.api.core.v1.CephFSVolumeSource] = None,
  awsElasticBlockStore : Option[io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource] = None,
  downwardAPI : Option[io.k8s.api.core.v1.DownwardAPIVolumeSource] = None,
  flexVolume : Option[io.k8s.api.core.v1.FlexVolumeSource] = None,
  emptyDir : Option[io.k8s.api.core.v1.EmptyDirVolumeSource] = None,
  nfs : Option[io.k8s.api.core.v1.NFSVolumeSource] = None,
  quobyte : Option[io.k8s.api.core.v1.QuobyteVolumeSource] = None,
  storageos : Option[io.k8s.api.core.v1.StorageOSVolumeSource] = None
) {
  def withSecret(value: io.k8s.api.core.v1.SecretVolumeSource) : Volume = copy(secret = Some(value))
  def withScaleIO(value: io.k8s.api.core.v1.ScaleIOVolumeSource) : Volume = copy(scaleIO = Some(value))
  def withCsi(value: io.k8s.api.core.v1.CSIVolumeSource) : Volume = copy(csi = Some(value))
  def withName(value: String) : Volume = copy(name = value)
  def withAzureDisk(value: io.k8s.api.core.v1.AzureDiskVolumeSource) : Volume = copy(azureDisk = Some(value))
  def withAzureFile(value: io.k8s.api.core.v1.AzureFileVolumeSource) : Volume = copy(azureFile = Some(value))
  def withHostPath(value: io.k8s.api.core.v1.HostPathVolumeSource) : Volume = copy(hostPath = Some(value))
  def withRbd(value: io.k8s.api.core.v1.RBDVolumeSource) : Volume = copy(rbd = Some(value))
  def withConfigMap(value: io.k8s.api.core.v1.ConfigMapVolumeSource) : Volume = copy(configMap = Some(value))
  def withPortworxVolume(value: io.k8s.api.core.v1.PortworxVolumeSource) : Volume = copy(portworxVolume = Some(value))
  def withGlusterfs(value: io.k8s.api.core.v1.GlusterfsVolumeSource) : Volume = copy(glusterfs = Some(value))
  def withFlocker(value: io.k8s.api.core.v1.FlockerVolumeSource) : Volume = copy(flocker = Some(value))
  def withFc(value: io.k8s.api.core.v1.FCVolumeSource) : Volume = copy(fc = Some(value))
  def withPhotonPersistentDisk(value: io.k8s.api.core.v1.PhotonPersistentDiskVolumeSource) : Volume = copy(photonPersistentDisk = Some(value))
  def withGcePersistentDisk(value: io.k8s.api.core.v1.GCEPersistentDiskVolumeSource) : Volume = copy(gcePersistentDisk = Some(value))
  def withPersistentVolumeClaim(value: io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource) : Volume = copy(persistentVolumeClaim = Some(value))
  def withVsphereVolume(value: io.k8s.api.core.v1.VsphereVirtualDiskVolumeSource) : Volume = copy(vsphereVolume = Some(value))
  def withProjected(value: io.k8s.api.core.v1.ProjectedVolumeSource) : Volume = copy(projected = Some(value))
  def withEphemeral(value: io.k8s.api.core.v1.EphemeralVolumeSource) : Volume = copy(ephemeral = Some(value))
  def withIscsi(value: io.k8s.api.core.v1.ISCSIVolumeSource) : Volume = copy(iscsi = Some(value))
  def withCinder(value: io.k8s.api.core.v1.CinderVolumeSource) : Volume = copy(cinder = Some(value))
  def withGitRepo(value: io.k8s.api.core.v1.GitRepoVolumeSource) : Volume = copy(gitRepo = Some(value))
  def withCephfs(value: io.k8s.api.core.v1.CephFSVolumeSource) : Volume = copy(cephfs = Some(value))
  def withAwsElasticBlockStore(value: io.k8s.api.core.v1.AWSElasticBlockStoreVolumeSource) : Volume = copy(awsElasticBlockStore = Some(value))
  def withDownwardAPI(value: io.k8s.api.core.v1.DownwardAPIVolumeSource) : Volume = copy(downwardAPI = Some(value))
  def withFlexVolume(value: io.k8s.api.core.v1.FlexVolumeSource) : Volume = copy(flexVolume = Some(value))
  def withEmptyDir(value: io.k8s.api.core.v1.EmptyDirVolumeSource) : Volume = copy(emptyDir = Some(value))
  def withNfs(value: io.k8s.api.core.v1.NFSVolumeSource) : Volume = copy(nfs = Some(value))
  def withQuobyte(value: io.k8s.api.core.v1.QuobyteVolumeSource) : Volume = copy(quobyte = Some(value))
  def withStorageos(value: io.k8s.api.core.v1.StorageOSVolumeSource) : Volume = copy(storageos = Some(value))
}

