package io.k8s.api.core.v1


/** A topology selector term represents the result of label queries. A null or empty topology selector term matches no objects. The requirements of them are ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an alpha feature and may change in the future. */
final case class TopologySelectorTerm(
  matchLabelExpressions : Option[Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]] = None
) {
  def withMatchLabelExpressions(value: Seq[io.k8s.api.core.v1.TopologySelectorLabelRequirement]) : TopologySelectorTerm = copy(matchLabelExpressions = Some(value))
  def addMatchLabelExpressions(newValues: io.k8s.api.core.v1.TopologySelectorLabelRequirement*) : TopologySelectorTerm = copy(matchLabelExpressions = Some(matchLabelExpressions.fold(newValues)(_ ++ newValues)))

}

