package io.k8s.api.core.v1


/** A topology selector requirement is a selector that matches given label. This is an alpha feature and may change in the future. */
final case class TopologySelectorLabelRequirement(
  key : String,
  values : Seq[String]
) {
  def withKey(value: String) : TopologySelectorLabelRequirement = copy(key = value)
  def withValues(value: Seq[String]) : TopologySelectorLabelRequirement = copy(values = value)
  def addValues(newValues: String*) : TopologySelectorLabelRequirement = copy(values = values ++ newValues)

}

