package io.k8s.api.core.v1


/** The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>. */
final case class Toleration(
  effect : Option[String] = None,
  key : Option[String] = None,
  tolerationSeconds : Option[Int] = None,
  operator : Option[String] = None,
  value : Option[String] = None
) {
  def withEffect(value: String) : Toleration = copy(effect = Some(value))
  def withKey(value: String) : Toleration = copy(key = Some(value))
  def withTolerationSeconds(value: Int) : Toleration = copy(tolerationSeconds = Some(value))
  def withOperator(value: String) : Toleration = copy(operator = Some(value))
  def withValue(value: String) : Toleration = copy(value = Some(value))
}

