package io.k8s.api.core.v1


/** The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint. */
final case class Taint(
  effect : String,
  key : String,
  timeAdded : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  value : Option[String] = None
) {
  def withEffect(value: String) : Taint = copy(effect = value)
  def withKey(value: String) : Taint = copy(key = value)
  def withTimeAdded(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Taint = copy(timeAdded = Some(value))
  def withValue(value: String) : Taint = copy(value = Some(value))
}

