package io.k8s.api.core.v1


/** ServiceStatus represents the current status of a service. */
final case class ServiceStatus(
  conditions : Option[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]] = None,
  loadBalancer : Option[io.k8s.api.core.v1.LoadBalancerStatus] = None
) {
  def withConditions(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.Condition]) : ServiceStatus = copy(conditions = Some(value))
  def addConditions(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.Condition*) : ServiceStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))

  def withLoadBalancer(value: io.k8s.api.core.v1.LoadBalancerStatus) : ServiceStatus = copy(loadBalancer = Some(value))
}

