package io.k8s.api.core.v1


/** ServiceSpec describes the attributes that a user creates on a service. */
final case class ServiceSpec(
  sessionAffinityConfig : Option[io.k8s.api.core.v1.SessionAffinityConfig] = None,
  loadBalancerSourceRanges : Option[Seq[String]] = None,
  sessionAffinity : Option[String] = None,
  clusterIPs : Option[Seq[String]] = None,
  externalTrafficPolicy : Option[String] = None,
  loadBalancerIP : Option[String] = None,
  clusterIP : Option[String] = None,
  ports : Option[Seq[io.k8s.api.core.v1.ServicePort]] = None,
  healthCheckNodePort : Option[Int] = None,
  allocateLoadBalancerNodePorts : Option[Boolean] = None,
  externalIPs : Option[Seq[String]] = None,
  ipFamilies : Option[Seq[String]] = None,
  internalTrafficPolicy : Option[String] = None,
  externalName : Option[String] = None,
  ipFamilyPolicy : Option[String] = None,
  `type` : Option[String] = None,
  selector : Option[Map[String, String]] = None,
  loadBalancerClass : Option[String] = None,
  publishNotReadyAddresses : Option[Boolean] = None
) {
  def withSessionAffinityConfig(value: io.k8s.api.core.v1.SessionAffinityConfig) : ServiceSpec = copy(sessionAffinityConfig = Some(value))
  def withLoadBalancerSourceRanges(value: Seq[String]) : ServiceSpec = copy(loadBalancerSourceRanges = Some(value))
  def addLoadBalancerSourceRanges(newValues: String*) : ServiceSpec = copy(loadBalancerSourceRanges = Some(loadBalancerSourceRanges.fold(newValues)(_ ++ newValues)))

  def withSessionAffinity(value: String) : ServiceSpec = copy(sessionAffinity = Some(value))
  def withClusterIPs(value: Seq[String]) : ServiceSpec = copy(clusterIPs = Some(value))
  def addClusterIPs(newValues: String*) : ServiceSpec = copy(clusterIPs = Some(clusterIPs.fold(newValues)(_ ++ newValues)))

  def withExternalTrafficPolicy(value: String) : ServiceSpec = copy(externalTrafficPolicy = Some(value))
  def withLoadBalancerIP(value: String) : ServiceSpec = copy(loadBalancerIP = Some(value))
  def withClusterIP(value: String) : ServiceSpec = copy(clusterIP = Some(value))
  def withPorts(value: Seq[io.k8s.api.core.v1.ServicePort]) : ServiceSpec = copy(ports = Some(value))
  def addPorts(newValues: io.k8s.api.core.v1.ServicePort*) : ServiceSpec = copy(ports = Some(ports.fold(newValues)(_ ++ newValues)))

  def withHealthCheckNodePort(value: Int) : ServiceSpec = copy(healthCheckNodePort = Some(value))
  def withAllocateLoadBalancerNodePorts(value: Boolean) : ServiceSpec = copy(allocateLoadBalancerNodePorts = Some(value))
  def withExternalIPs(value: Seq[String]) : ServiceSpec = copy(externalIPs = Some(value))
  def addExternalIPs(newValues: String*) : ServiceSpec = copy(externalIPs = Some(externalIPs.fold(newValues)(_ ++ newValues)))

  def withIpFamilies(value: Seq[String]) : ServiceSpec = copy(ipFamilies = Some(value))
  def addIpFamilies(newValues: String*) : ServiceSpec = copy(ipFamilies = Some(ipFamilies.fold(newValues)(_ ++ newValues)))

  def withInternalTrafficPolicy(value: String) : ServiceSpec = copy(internalTrafficPolicy = Some(value))
  def withExternalName(value: String) : ServiceSpec = copy(externalName = Some(value))
  def withIpFamilyPolicy(value: String) : ServiceSpec = copy(ipFamilyPolicy = Some(value))
  def withType(value: String) : ServiceSpec = copy(`type` = Some(value))
  def withSelector(value: Map[String, String]) : ServiceSpec = copy(selector = Some(value))
  def addSelector(newValues: (String, String)*) : ServiceSpec = copy(selector = Some(selector.fold(newValues.toMap)(_ ++ newValues)))

  def withLoadBalancerClass(value: String) : ServiceSpec = copy(loadBalancerClass = Some(value))
  def withPublishNotReadyAddresses(value: Boolean) : ServiceSpec = copy(publishNotReadyAddresses = Some(value))
}

