package io.k8s.api.core.v1


/** ServicePort contains information on service's port. */
final case class ServicePort(
  nodePort : Option[Int] = None,
  name : Option[String] = None,
  port : Int,
  targetPort : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  protocol : Option[String] = None,
  appProtocol : Option[String] = None
) {
  def withNodePort(value: Int) : ServicePort = copy(nodePort = Some(value))
  def withName(value: String) : ServicePort = copy(name = Some(value))
  def withPort(value: Int) : ServicePort = copy(port = value)
  def withTargetPort(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : ServicePort = copy(targetPort = Some(value))
  def withProtocol(value: String) : ServicePort = copy(protocol = Some(value))
  def withAppProtocol(value: String) : ServicePort = copy(appProtocol = Some(value))
}

