package io.k8s.api.core.v1


/** ServiceAccountTokenProjection represents a projected service account token volume. This projection can be used to insert a service account token into the pods runtime filesystem for use against APIs (Kubernetes API Server or otherwise). */
final case class ServiceAccountTokenProjection(
  audience : Option[String] = None,
  expirationSeconds : Option[Int] = None,
  path : String
) {
  def withAudience(value: String) : ServiceAccountTokenProjection = copy(audience = Some(value))
  def withExpirationSeconds(value: Int) : ServiceAccountTokenProjection = copy(expirationSeconds = Some(value))
  def withPath(value: String) : ServiceAccountTokenProjection = copy(path = value)
}

