package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceAccountList is a list of ServiceAccount objects */
final case class ServiceAccountList(
  items : Seq[io.k8s.api.core.v1.ServiceAccount],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceAccountList", "v1")

  def withItems(value: Seq[io.k8s.api.core.v1.ServiceAccount]) : ServiceAccountList = copy(items = value)
  def addItems(newValues: io.k8s.api.core.v1.ServiceAccount*) : ServiceAccountList = copy(items = items ++ newValues)

  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : ServiceAccountList = copy(metadata = Some(value))
}

