package io.k8s.api.core.v1

import dev.hnaderi.k8s._

/** ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets */
final case class ServiceAccount(
  imagePullSecrets : Option[Seq[io.k8s.api.core.v1.LocalObjectReference]] = None,
  secrets : Option[Seq[io.k8s.api.core.v1.ObjectReference]] = None,
  automountServiceAccountToken : Option[Boolean] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ServiceAccount", "v1")

  def withImagePullSecrets(value: Seq[io.k8s.api.core.v1.LocalObjectReference]) : ServiceAccount = copy(imagePullSecrets = Some(value))
  def addImagePullSecrets(newValues: io.k8s.api.core.v1.LocalObjectReference*) : ServiceAccount = copy(imagePullSecrets = Some(imagePullSecrets.fold(newValues)(_ ++ newValues)))

  def withSecrets(value: Seq[io.k8s.api.core.v1.ObjectReference]) : ServiceAccount = copy(secrets = Some(value))
  def addSecrets(newValues: io.k8s.api.core.v1.ObjectReference*) : ServiceAccount = copy(secrets = Some(secrets.fold(newValues)(_ ++ newValues)))

  def withAutomountServiceAccountToken(value: Boolean) : ServiceAccount = copy(automountServiceAccountToken = Some(value))
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ServiceAccount = copy(metadata = Some(value))
}

